# Proyecto 3.2. Preparando el fútbol de robots, sin procedimientos

En esta actividad solamente tenés que mirar el programa que está realizado, y comprobar 
qué difícil que es entender qué hace el programa cuando no se utilizan procedimientos para 
representar los elementos ni las operaciones del problema. 
¡Es mucho mejor definir procedimientos para representar las ideas!

<center>
![El principio del código sin procedimientos](data:image/png;base64,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)
</center>

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/2.Procedimientos/3.2.Preparando%20el%20f%C3%BAtbol%20de%20robots%2C%20sin%20procedimientos/assets/resources/description.pdf "Enunciado de 'Preparando el fútbol de robots, sin procedimientos' en PDF"
